;------------------------------------------------------------------------
; Panasonic 3DO
; FreeDO v2.1.1 alpha
; by chillinwater & djvj
; 1.2
;
; Notes:
; The emu does not support CLI or a way of launching fullscreen by default. This is all done manually in the script.
; Supported images are iso, cdi, nrg, bin, img. Cues are not supported. Set your extensions appropriately.
; If your bios file is called fz10_rom.bin, rename it to fz10.rom, it should be placed in the same dir as the emu exe.
; On first launch, FreeDO will ask you to point it to the fz10.rom. After you do that, exit the emu and select a game in HS and it should work.
; If the Menu bar at top is present on launch, Hit F9 and exit to save.
; The optional blinds were left in in case you want to test if they help hide the emu launch process. They did nothing for me on win7, so results may vary.
;
; Create a restore.xml or follow the next line. For info on how to do this, go here http://www.hyperspin-fe.com/forum/showpost.php?p=58411&postcount=12
; In the emu dir, rename config.xml to restore.xml then open it in notepad. Remove the entire section including <cdrom> and </cdrom> (this fixes not being able to play the game twice in a row)
; If you change inputs or make any other changes, make sure to copy the changes from the config.xml into your restore.xml
;------------------------------------------------------------------------

;\\\optional blinds\\\\
;Gui +AlwaysOnTop -Caption +ToolWindow 
;Gui, color, 0
;Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%, 
;\\\\\\\\\\\\\\\\\\\\\\

; restoring a proper config.xml
FileDelete, %emuPath%config.xml
FileCopy, %emuPath%restore.xml, %emuPath%config.xml
 
Run, %executable%, %emuPath%
DetectHiddenWindows, on
Sleep, 500
WinWait, FreeDO v.2.1
IfWinNotActive, FreeDO v.2.1, , WinActivate, FreeDO v.2.1
WinWaitActive, FreeDO v.2.1
Send, {ALTDOWN}{ALTUP}{UP}{ENTER} ; open ISO
WinWait, Open
IfWinNotActive, Open, , WinActivate, Open
WinWaitActive, Open
Sleep, 500
clipboard=
clipboard=%romPath%%romName%%romExtension%
ClipWait
Sleep, 500 ; increase this if your clipboard is not pasting in
Send, ^v
Sleep,100
Send, {ENTER}
Sleep, 100
Send, {F11} ; fullscreen
Sleep, 500
Send, {F9} ; disable toolbar
Sleep, 2000
Gui Destroy 
Process, WaitClose, %executable%
WinActivate, HyperSpin

ExitApp
 
CloseProcess:
	WinClose, FreeDO
return